#!/bin/sh

TP_ESXI_IMAGE_SELECT_RESULT_OK="DTAS[TUI]@{OK}"
TP_ESXI_IMAGE_SELECT_RESULT_CANCEL="DTAS[TUI]@{CANCEL}"
TP_ESXI_IMAGE_SELECT_RESULT_CTRLC="DTAS[TUI]@{CTRLC}"
TP_ESXI_IMAGE_SELECT_RESULT_ERROR="DTAS[TUI]@{ERROR}"
TP_ESXI_IMAGE_SELECT_RESULT_CODE=""

TP_ESXI_IMAGE_SELECT_RESULT_MSG=""

TP_ESXI_IMAGE_SELECT_RESULT_SELECT=""
TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH=""
TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH_VIX=""

tp_esxi_image_select() {
    debug_print "in function '${FUNCNAME[0]}'"
    
    local title="${1}"
    local text="${2}"
    local label_ok="${3}"
    local label_cancel="${4}"
    local esxi_ip="${5}"
    local esxi_username="${6}"
    local esxi_password="${7}"
    local prefix="${8}"
    
    local ret
    utility_get_esxi_all_vmx_files \
        "${esxi_ip}" \
        "${esxi_username}" \
        "${esxi_password}" \
        "${prefix}"
    ret="${?}"
    if [ "${ret}" -eq 2 -o "${ret}" -eq 130 ]; then
        TP_ESXI_IMAGE_SELECT_RESULT_CODE="${TP_ESXI_IMAGE_SELECT_RESULT_CTRLC}"
        TP_ESXI_IMAGE_SELECT_RESULT_MSG=""
        return
    
    elif [ "${ret}" -ne 0 ]; then
        TP_ESXI_IMAGE_SELECT_RESULT_CODE="${TP_ESXI_IMAGE_SELECT_RESULT_ERROR}"
        TP_ESXI_IMAGE_SELECT_RESULT_MSG="${TP_ESXI_IMAGE_SELECT_ERROR_GET_ALL_VMX_FILES}"
        return
    fi
    debug_print "All vmx files: ${UTILITY_GET_ESXI_ALL_VMX_FILES_MSG}"
    
    
    ##################################################
    # pick up vmx files with
    #     specific prefix: SandboxController
    ##################################################
    local vmx_files_to_display="${UTILITY_GET_ESXI_ALL_VMX_FILES_MSG}"
    debug_print "vmx files to display: ${vmx_files_to_display}"
    
    
    ##################################################
    # translate long format to short format
    #   ex. /vmfs/<ds_uid>/A/A.vmx => A
    ##################################################
    local short_names
    local vmx_file
    for vmx_file in $vmx_files_to_display
    do
        local file_name=`echo "${vmx_file}" | awk 'BEGIN {FS="/"} {print $6}'`
        local short_format="`echo "${file_name}" | sed "s/.vmx$//g"`"
        
        [ -z "${short_names}" ] && \
            short_names="${short_format}" || \
            short_names="${short_names} ${short_format}"
    done
    
    # change to array type
    debug_print "vmx files to display(short version): ${short_names}"
    local short_names_array=(${short_names})
    local long_names_array=(${vmx_files_to_display})
    

    ##################################################
    # composing menu list to display on TUI
    ##################################################
    local menu_list=""
    local short_name
    for short_name in ${short_names}
    do
        menu_list="${menu_list} \"${short_name}\" \"\""
    done
    debug_print "GetMenuList: ${menu_list}"

    
    ##################################################
    # display menu
    ##################################################
    if [ "${#short_names_array[@]}" -ne 1 ]; then
        tp_menu_ok_cancel \
            "${title}" \
            "${text}" \
            "${label_ok}" \
            "${label_cancel}" \
            "${menu_list}"
        debug_print "UserSelect(Short): ${TP_MENU_OK_CANCEL_RESULT_SELECT}"    
        TP_ESXI_IMAGE_SELECT_RESULT_SELECT="${TP_MENU_OK_CANCEL_RESULT_SELECT}"
        
        case "${TP_MENU_OK_CANCEL_RESULT_CODE}" in
            "${TP_MENU_OK_CANCEL_RESULT_CANCEL}" )
                TP_ESXI_IMAGE_SELECT_RESULT_CODE="$TP_ESXI_IMAGE_SELECT_RESULT_CANCEL"
                TP_ESXI_IMAGE_SELECT_RESULT_MSG=""
                return
                ;;
        esac
    else
        debug_print "OnlyOneImageFound(Short): '${short_names}'"
        debug_print "AutoSelect:(Short): '${short_names}'"
        
        TP_ESXI_IMAGE_SELECT_RESULT_SELECT="${short_names}"
        TP_ESXI_IMAGE_SELECT_RESULT_CODE="$TP_ESXI_IMAGE_SELECT_RESULT_CANCEL"
        TP_ESXI_IMAGE_SELECT_RESULT_MSG=""
        
    fi

    ##################################################
    # get corresponding long format according to user selects
    #   ex. /vmfs/volumes/<datastore_uid>/sandbox/sandbox.vmx
    ##################################################    
    local long_names_user_selects
    local user_select
    for user_select in ${TP_ESXI_IMAGE_SELECT_RESULT_SELECT}
    do
        local i
        for ((i=0; i<${#short_names_array[@]}; i++)); do
            local sn="${short_names_array[$i]}"
            if [ "${user_select}" = "${sn}" ]; then
                local ln="${long_names_array[$i]}"
                
                [ -z "${long_names_user_selects}" ] && \
                    long_names_user_selects="${ln}" || \
                    long_names_user_selects="${long_names_user_selects},${ln}"
            fi
        done
    done
    debug_print "UserSelect(Long): ${long_names_user_selects}"
    TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH="${long_names_user_selects}"

    
    ##################################################
    # get corresponding long format (VIX) according to user selects
    #   ex. [ha-datacenter/<datastore_name>] sandbox/sandbox.vmx
    ##################################################
    TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH_VIX=""
    
    # turn-on esxi sshd services
    utility_tui_signal_lock
    utility_open_esxi_service_sshd \
        "${esxi_ip}" \
        "${esxi_username}" \
        "${esxi_password}"
    ret="${?}"
    if [ "${ret}" -eq 2 -o "${ret}" -eq 130 ]; then
        debug_print "EnableESXiServiceSshdCtrlC: ret='${ret}', msg='${UTILITY_OPEN_ESXI_SERVICE_SSHD_MSG}'"
    
        utility_tui_signal_unlock
        TP_ESXI_IMAGE_SELECT_RESULT_SELECT="${TP_MENU_OK_CANCEL_RESULT_SELECT}"
        TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH_VIX=""
        TP_ESXI_IMAGE_SELECT_RESULT_CODE="${TP_ESXI_IMAGE_SELECT_RESULT_CTRLC}"
        TP_ESXI_IMAGE_SELECT_RESULT_MSG=""
        return "${ret}"
    
    elif [ "${ret}" -ne 0 ]; then
        debug_print "EnableESXiServiceSshdFail: ret='${ret}', msg='${UTILITY_OPEN_ESXI_SERVICE_SSHD_MSG}'"
        
        utility_tui_signal_unlock
        TP_ESXI_IMAGE_SELECT_RESULT_SELECT="${TP_MENU_OK_CANCEL_RESULT_SELECT}"
        TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH_VIX=""
        TP_ESXI_IMAGE_SELECT_RESULT_CODE="${TP_ESXI_IMAGE_SELECT_RESULT_ERROR}"
        TP_ESXI_IMAGE_SELECT_RESULT_MSG="${UTILITY_OPEN_ESXI_SERVICE_SSHD_MSG}"
        return "${ret}"
    fi
    
    # convert
    local vm_path_vsphere
    for vm_path_vsphere in `echo "${long_names_user_selects}" | sed 's/,/ /g'`
    do
        debug_print "ConvertVmpathFromVsphereToVix: vmPathVsphere='${vm_path_vsphere}'"	
        
        local msg
        msg=`php $CONS_BACKEND convert_esxi_vmpath_from_vsphere_to_vix \
            "${esxi_ip}" \
            "${esxi_username}" \
            "${esxi_password}" \
            "${vm_path_vsphere}"`
        local ret="${?}"
        if [ "${ret}" -eq 2 -o "${ret}" -eq 130 ]; then
            debug_print "ConvertVmpathFromVsphereToVixCtrlC: ret='${ret}', msg='${msg}'"
        
            utility_tui_signal_unlock
            TP_ESXI_IMAGE_SELECT_RESULT_SELECT="${TP_MENU_OK_CANCEL_RESULT_SELECT}"
            TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH_VIX=""
            TP_ESXI_IMAGE_SELECT_RESULT_CODE="${TP_ESXI_IMAGE_SELECT_RESULT_CTRLC}"
            TP_ESXI_IMAGE_SELECT_RESULT_MSG=""
            return "${ret}"
        
        elif [ "${ret}" -ne 0 ]; then
            debug_print "ConvertVmpathFromVsphereToVixFail: ret='${ret}', msg='${msg}'"	
            
            utility_tui_signal_unlock
            TP_ESXI_IMAGE_SELECT_RESULT_SELECT="${TP_MENU_OK_CANCEL_RESULT_SELECT}"
            TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH_VIX=""
            TP_ESXI_IMAGE_SELECT_RESULT_CODE="${TP_ESXI_IMAGE_SELECT_RESULT_ERROR}"
            TP_ESXI_IMAGE_SELECT_RESULT_MSG="${TP_ESXI_IMAGE_SELECT_ERROR_CONVERT_TO_ESXI_VMPATH}: ${vm_path_vsphere}"
            return
        fi
        debug_print "ConvertVmpathFromVsphereToVixPass: vmPathVsphere='${vm_path_vsphere}', vmPathVix='${msg}'"	

        # append to variable
        [ -z "${TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH_VIX}" ] \
            && TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH_VIX="${msg}" \
            || TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH_VIX="${TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH_VIX},${msg}"
    done
    
    # done
    debug_print "UserSelect(VIX): ${TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH_VIX}"

    # turn-off esxi sshd service
    utility_close_esxi_service_sshd \
        "${esxi_ip}" \
        "${esxi_username}" \
        "${esxi_password}"
    utility_tui_signal_unlock
    
    TP_ESXI_IMAGE_SELECT_RESULT_CODE="${TP_ESXI_IMAGE_SELECT_RESULT_OK}"
    TP_ESXI_IMAGE_SELECT_RESULT_MSG=""
    return
}	
